# バッチ設計書 3-TTL After Finished Controller

## 概要

本ドキュメントは、完了したJobをTTL（Time To Live）に基づいて自動削除するTTL After Finished Controllerの設計を記述する。

### 本バッチの処理概要

TTL After Finished Controllerは、完了済みJob（Complete/Failed状態）に設定されたTTLに基づいて、自動的にJobリソースを削除するコントローラーである。

**業務上の目的・背景**：Kubernetesクラスタ上で大量のバッチジョブが実行されると、完了済みJobがetcdに蓄積され、ストレージの圧迫やリソース管理の煩雑さが生じる。TTL After Finished Controllerは、ユーザーが`spec.ttlSecondsAfterFinished`を設定するだけで、完了後のJobを自動的にクリーンアップする仕組みを提供し、クラスタの健全性を維持する。

**バッチの実行タイミング**：Jobリソースの作成・更新イベントをInformerで監視し、ttlSecondsAfterFinishedが設定されたJobをキューに追加する。TTL到達時にDelayingQueueにより再処理される。

**主要な処理内容**：
1. Jobリソースの監視（Informer経由でAdd/Updateイベント）
2. ttlSecondsAfterFinished設定チェック（needsCleanup判定）
3. TTL経過判定（completionTime + TTL vs 現在時刻）
4. TTL未到達の場合、残り時間後にキューへ再投入（AddAfter）
5. TTL到達済みの場合、API Serverへ削除リクエスト送信
6. 削除前のフレッシュネスチェック（API Serverから最新状態を再取得）

**前後の処理との関連**：Job Controllerが管理するJobの完了後に本コントローラーが処理する。削除されたJobに関連するPodはGarbage Collectorがカスケード削除する。

**影響範囲**：Jobリソースの削除。カスケード削除により関連Podも影響を受ける。

## バッチ種別

ガベージコレクション型（TTLベースリソース自動削除）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | イベント駆動 + TTLタイマー駆動 |
| 実行時刻 | Job完了後のTTL経過時 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | Jobリソースの作成/更新イベント、DelayingQueueタイマー |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| kube-controller-manager起動 | TTL After Finished Controllerはkube-controller-manager内で起動 |
| Informerキャッシュ同期完了 | JobのInformerキャッシュが同期済みであること |
| API Server接続 | kube-apiserverと通信可能であること |

### 実行可否判定

Jobのspec.ttlSecondsAfterFinishedが設定されており（needsCleanup関数）、かつJobが完了状態（Complete/Failed）であること。DeletionTimestampがnilであること（削除中でないこと）。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| workers | int | Yes | なし | ワーカーの並列数 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| Job Informer | Kubernetes API (batch/v1 Job) | Jobリソースの変更イベントを監視 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Job (削除) | Kubernetes API (batch/v1 Job) | TTL経過済みJobの削除リクエスト |
| Event | Kubernetes API (core/v1 Event) | Job削除イベントの記録 |

### 出力ファイル仕様

ファイル出力はなし。

## 処理フロー

### 処理シーケンス

```
1. コントローラー初期化（New）
   └─ Informer登録、workqueue作成、clock初期化
2. Run起動
   └─ EventBroadcaster開始、キャッシュ同期待ち、ワーカーgoroutine起動
3. addJob/updateJob
   └─ DeletionTimestamp == nil && needsCleanup(job) の場合、キューに追加
4. processJob処理
   ├─ Listerから最新Job取得
   ├─ needsCleanup判定
   ├─ TTL残り時間計算
   ├─ 残り時間 > 0: enqueueAfterで再キュー
   └─ 残り時間 <= 0: API Serverから再取得後に削除
5. エラーハンドリング
   └─ handleErrでレートリミット付きリキュー
```

### フローチャート

```mermaid
flowchart TD
    A[Jobイベント受信] --> B{DeletionTimestamp == nil?}
    B -->|Yes| C{needsCleanup?}
    B -->|No| D[スキップ]
    C -->|Yes| E[キューに追加]
    C -->|No| D
    E --> F[processJob]
    F --> G{TTL経過?}
    G -->|No| H[残り時間後に再キュー]
    G -->|Yes| I[API Serverから最新取得]
    I --> J{まだ削除対象?}
    J -->|Yes| K[Job削除リクエスト]
    J -->|No| L[スキップ]
    H --> F
```

## データベース操作仕様

### 操作別データベース影響一覧

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Job取得 | etcd (jobs) | SELECT | Lister経由のキャッシュ読み取り |
| Job再取得 | etcd (jobs) | SELECT | API Server直接取得（フレッシュネスチェック） |
| Job削除 | etcd (jobs) | DELETE | TTL経過済みJobの削除 |

### テーブル別操作詳細

#### Job (batch/v1)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | spec.ttlSecondsAfterFinished | 非nil | needsCleanup判定 |
| SELECT | status.conditions | Complete/Failed | 完了判定 |
| DELETE | - | TTL経過済み | カスケード削除 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Job NotFound | Jobが既に削除済み | 処理スキップ |
| - | API Server通信エラー | API Server到達不能 | レートリミット付きリキュー |
| - | 削除失敗 | 権限不足等 | エラーログ出力、リキュー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 無制限（レートリミッター制御） |
| リトライ間隔 | TypedRateLimitingQueue（指数バックオフ） |
| リトライ対象エラー | API Server通信エラー、削除操作エラー |

### 障害時対応

コントローラー再起動時にInformerキャッシュ再同期により、TTL設定のある全Jobが再評価される。TTL判定はJobのcompletionTimeとclock.Now()の比較で冪等に動作する。

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Job単位（1 processJobコール = 1 Job） |
| コミットタイミング | 削除APIコール時 |
| ロールバック条件 | 削除失敗時はリキューで再試行 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | クラスタ内TTL設定済みJob数に依存 |
| 目標処理時間 | ワーカーループ間隔 = 1秒 |
| メモリ使用量上限 | Informerキャッシュサイズに依存 |

## 排他制御

- workqueueによるキー単位の排他制御
- フレッシュネスチェック（削除前にAPI Serverから最新状態を再取得）
- API Serverの楽観的並行性制御

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | コントローラー起動時 | "Starting TTL after finished controller" |
| 進捗ログ | addJob/updateJob時（V4） | "Adding job", "Updating job" |
| 終了ログ | コントローラー停止時 | "Shutting down TTL after finished controller" |
| エラーログ | エラー発生時 | "error cleaning up Job" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ttl_after_finished_controller メトリクス | メトリクス（Prometheusで監視） | クラスタ管理者 |
| workqueue深さ | メトリクス（Prometheusで監視） | クラスタ管理者 |

## 備考

- ソースコード: `pkg/controller/ttlafterfinished/ttlafterfinished_controller.go`
- Job Controller外で実装されている理由: 関心の分離と、将来的に他の完了可能リソースタイプへの拡張を想定
- キュー名: `ttl_jobs_to_delete`
- clock.RealClockを使用（テスト時にインジェクション可能）
